unit AutomAddinSample_TLB;

{$TYPEDADDRESS OFF}
{$WARN SYMBOL_PLATFORM OFF}
{$WRITEABLECONST ON}
{$VARPROPSETTER ON}
{$ALIGN 4}
interface

uses Windows, ActiveX, Classes, Variants;
  
const
  AutomAddinSampleMajorVersion = 1;
  AutomAddinSampleMinorVersion = 0;

  LIBID_AutomAddinSample: TGUID = '{1B77B758-6EF2-4F78-8B0E-2BE406B88AAF}';

  IID_IDelphiAddin: TGUID = '{4A6B90E0-598C-4795-B645-0D631203307C}';
  CLASS_DelphiAddin: TGUID = '{B8D9B2DB-399E-4B5D-8373-BFC7FD129536}';
type

  IDelphiAddin = interface;
  IDelphiAddinDisp = dispinterface;

  DelphiAddin = IDelphiAddin;

  IDelphiAddin = interface(IDispatch)
    ['{4A6B90E0-598C-4795-B645-0D631203307C}']
    function SimpleAdd(X: Double; Y: Double): Double; safecall;
  end;

  IDelphiAddinDisp = dispinterface
    ['{4A6B90E0-598C-4795-B645-0D631203307C}']
    function SimpleAdd(X: Double; Y: Double): Double; dispid 201;
  end;

  CoDelphiAddin = class
    class function Create: IDelphiAddin;
    class function CreateRemote(const MachineName: string): IDelphiAddin;
  end;

implementation

uses ComObj;

class function CoDelphiAddin.Create: IDelphiAddin;
begin
  Result := CreateComObject(CLASS_DelphiAddin) as IDelphiAddin;
end;

class function CoDelphiAddin.CreateRemote(const MachineName: string): IDelphiAddin;
begin
  Result := CreateRemoteComObject(MachineName, CLASS_DelphiAddin) as IDelphiAddin;
end;

end.
