unit Unit1;

interface

uses
  ComObj, ActiveX, AutomAddinSample_TLB;

type
  TDelphiAddin = class(TAutoObject, IDelphiAddin)
  protected
    function SimpleAdd(X, Y: Double): Double; safecall;
  end;

type
  TAutomationAddInFactory = class(TAutoObjectFactory)
  public
    procedure UpdateRegistry(Register: Boolean); override;
  end;

implementation

uses ComServ, Windows;

function TDelphiAddin.SimpleAdd(X, Y: Double): Double;
begin
  result:=X + Y;
end;

procedure TAutomationAddInFactory.UpdateRegistry(Register: Boolean);
var
  ClassKey: string;
  RegPrefix: string;
  RootKey: HKEY;
begin
  {$IF CompilerVersion >= 22.0}
  ComServer.GetRegRootAndPrefix(RootKey, RegPrefix);
  {$ELSE} // per user registration not implemented
  Rootkey:=HKEY_CLASSES_ROOT;
  RegPrefix:='';
  {$IFEND}
  ClassKey:=RegPrefix + 'CLSID\' + GUIDToString(ClassID);
  if Register then begin
    inherited UpdateRegistry(Register);
    CreateRegKey(ClassKey + '\Programmable', '', '', RootKey);
  end
  else begin
    DeleteRegKey(ClassKey + '\Programmable', RootKey);
    inherited UpdateRegistry(Register);
  end;
end;

initialization
  TAutomationAddInFactory.Create(ComServer, TDelphiAddin,
    Class_DelphiAddin, ciMultiInstance, tmApartment);
end.
