{ *********************************************************************** }
{                                                                         }
{ Delphi EXceL Utilities Unit                                             }
{                                                                         }
{ Defines some useful things that work similar to the                     }
{ framework sample in the Microsoft Excel Developer's Toolkit             }
{                                                                         }
{ Copyright (c) 2012, 2013 Edgar Gttel                                   }
{                                                                         }
{ *********************************************************************** }
unit dXLUtils;

interface

uses
  dXLCall;

function Excel4e(xlfn: integer; operRes: LPXLOPER;
  count: integer = 0; opers: PLPXLOPERarray = nil): integer; overload;
function Excel4e(xlfn: integer; var operRes: XLOPER;
  count: integer = 0; opers: PLPXLOPERarray = nil): integer; overload;
function Excel4e(xlfn: integer; operRes: LPXLOPER;
  count: integer; opers: array of LPXLOPER): integer; overload;
function Excel4e(xlfn: integer; var operRes: XLOPER;
  count: integer; opers: array of LPXLOPER): integer; overload;

function Excel12e(xlfn: integer; operRes: LPXLOPER12;
  count: integer = 0; opers: PLPXLOPER12array = nil): integer; overload;
function Excel12e(xlfn: integer; var operRes: XLOPER12;
  count: integer = 0; opers: PLPXLOPER12array = nil): integer; overload;
function Excel12e(xlfn: integer; operRes: LPXLOPER12;
  count: integer; opers: array of LPXLOPER12): integer; overload;
function Excel12e(xlfn: integer; var operRes: XLOPER12;
  count: integer; opers: array of LPXLOPER12): integer; overload;

implementation

function Excel4e(xlfn: integer; operRes: LPXLOPER;
  count: integer = 0; opers: PLPXLOPERarray = nil): integer; overload;
begin
  result:= Excel4v(xlfn, operRes, count, opers);
end;

function Excel4e(xlfn: integer; var operRes: XLOPER;
  count: integer = 0; opers: PLPXLOPERarray = nil): integer; overload;
begin
  result:= Excel4v(xlfn, @operRes, count, opers);
end;

function Excel4e(xlfn: integer; operRes: LPXLOPER;
  count: integer; opers: array of LPXLOPER): integer; overload;
begin
  result:= Excel4v(xlfn, operRes, count, @opers);
end;

function Excel4e(xlfn: integer; var operRes: XLOPER;
  count: integer; opers: array of LPXLOPER): integer; overload;
begin
  result:= Excel4v(xlfn, @operRes, count, @opers);
end;

function Excel12e(xlfn: integer; operRes: LPXLOPER12;
  count: integer = 0; opers: PLPXLOPER12array = nil): integer; overload;
begin
  result:= Excel12v(xlfn, operRes, count, opers);
end;

function Excel12e(xlfn: integer; var operRes: XLOPER12;
  count: integer = 0; opers: PLPXLOPER12array = nil): integer; overload;
begin
  result:= Excel12v(xlfn, @operRes, count, opers);
end;

function Excel12e(xlfn: integer; operRes: LPXLOPER12;
  count: integer; opers: array of LPXLOPER12): integer; overload;
begin
  result:= Excel12v(xlfn, operRes, count, @opers);
end;

function Excel12e(xlfn: integer; var operRes: XLOPER12;
  count: integer; opers: array of LPXLOPER12): integer; overload;
begin
  result:= Excel12v(xlfn, @operRes, count, @opers);
end;

end.
