{ *********************************************************************** }
{                                                                         }
{ Copyright (c) 2012, 2013 Edgar Gttel                                   }
{                                                                         }
{ *********************************************************************** }
library SampleXLLHello;

uses
  dXLCall, dXLUtils;

{$E XLL}

const
  XLLName : PAnsiChar = #12'Hello Add-In';
  Msg : PAnsiChar = #11'Hello World';
  FncP : PAnsiChar = #10'SampleFunc';
  FncT : PAnsiChar = #01'P';
  FncF : PAnsiChar = #10'HelloFnc';

var
  isRegistered: Boolean;
  res, Arg1, Arg2, Arg3, Arg4 : xloper;

function SampleFunc: LPXLOPER; stdcall;
begin
  res.xltype:= xltypeStr;
  res.val.str:= Msg;
  result:=@res;
end;

function xlAddInManagerInfo(pxAction: LPXLOPER): LPXLOPER; stdcall;
begin
  if ((pxAction.xltype = xltypeInt)and(pxAction.val.w = 1))or
     ((pxAction.xltype = xltypeNum)and(pxAction.val.num = 1)) then begin
    res.xltype:= xltypeStr;
    res.val.Str:= XLLName;
  end
  else begin
    res.xltype:= xltypeErr;
    res.val.err:= xlerrValue;
  end;
  result:=@res;
end;

function xlAutoOpen: integer; stdcall;
begin
  if not isRegistered then begin
    Excel4e(xlGetName, @Arg1);        // dll name as pxModuleText
    Arg2.xltype:= xltypeStr;
    Arg2.val.str:= FncP;
    Arg3.xltype:= xltypeStr;
    Arg3.val.str:= FncT;
    Arg4.xltype:= xltypeStr;
    Arg4.val.str:= FncF;
    Excel4e(xlfRegister, nil, 4,      // registers the function
      [@Arg1, @Arg2, @Arg3, @Arg4]);
    Excel4e(xlFree, nil, 1, [@Arg1]); // free this string!
    isRegistered:= true;
  end;
  result:= 1;
end;

function xlAutoRemove: integer; stdcall;
begin
  if isRegistered then begin
    Excel4e(xlGetName, @Arg1);         // dll name as pxModuleText
    Arg2.xltype:= xltypeStr;
    Arg2.val.str:= FncP;
    Arg3.xltype:= xltypeStr;
    Arg3.val.str:= FncT;
    Arg4.xltype:= xltypeStr;
    Arg4.val.str:= FncF;
    Excel4e(xlfRegisterId, @res, 3,    // for Unregister
      [@Arg1, @Arg2, @Arg3]);
    Excel4e(xlfSetName, nil, 1, [@Arg4]);   // delete name
    Excel4e(xlfUnregister, nil, 1, [@res]); // unregister function
    Excel4e(xlFree, nil, 1, [@Arg1]);  // free this string!
    isRegistered:= false;
  end;
  result:= 1;
end;

exports
  SampleFunc,
  xlAddInManagerInfo,
  xlAutoOpen,
  xlAutoRemove;

begin
  isRegistered:=false;
end.

