unit Unit1;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, ActiveX, XLCOMSample1_TLB;

type
  TXLComAddinFactory = class(TAutoObjectFactory)
    procedure UpdateRegistry(Register: Boolean); override;
  end;

// Constants for enum ext_ConnectMode
type
  ext_ConnectMode = TOleEnum;

const
  ext_cm_AfterStartup = $00000000;
  ext_cm_Startup = $00000001;
  ext_cm_External = $00000002;
  ext_cm_CommandLine = $00000003;

// Constants for enum ext_DisconnectMode
type
  ext_DisconnectMode = TOleEnum;

const
  ext_dm_HostShutdown = $00000000;
  ext_dm_UserClosed = $00000001;

type
  IDTExtensibility2 = interface(IDispatch)
    ['{B65AD801-ABAF-11D0-BB8B-00A0C90F2744}']
    procedure OnConnection(const Application: IDispatch;
                           ConnectMode: ext_ConnectMode;
                           const AddInInst: IDispatch;
                           var custom: PSafeArray); safecall;
    procedure OnDisconnection(RemoveMode: ext_DisconnectMode;
                              var custom: PSafeArray); safecall;
    procedure OnAddInsUpdate(var custom: PSafeArray); safecall;
    procedure OnStartupComplete(var custom: PSafeArray); safecall;
    procedure OnBeginShutdown(var custom: PSafeArray); safecall;
  end;

type
  TDelphiAddin1 = class(TAutoObject, IDelphiAddin1, IDTExtensibility2)
  private
    procedure OnConnection(const Application: IDispatch;
                           ConnectMode: ext_ConnectMode;
                           const AddInInst: IDispatch;
                           var custom: PSafeArray); safecall;
    procedure OnDisconnection(RemoveMode: ext_DisconnectMode;
                              var custom: PSafeArray); safecall;
    procedure OnAddInsUpdate(var custom: PSafeArray); safecall;
    procedure OnStartupComplete(var custom: PSafeArray); safecall;
    procedure OnBeginShutdown(var custom: PSafeArray); safecall;
  protected

  end;

implementation

uses
  ComServ, Windows, Registry;

{ TXLComAddinFactory }

procedure TXLComAddinFactory.UpdateRegistry(Register: Boolean);
var
  RootKey: HKEY;
  AddInKey: String;
  r: TRegistry;
begin
  Rootkey:=HKEY_CURRENT_USER;
  AddInKey:='Software\Microsoft\Office\Excel\Addins\' + ProgID;
  r:=TRegistry.Create;
  r.RootKey:=RootKey;
  try
    if Register then
      if r.OpenKey(AddInKey, True) then begin
        r.WriteInteger('LoadBehavior', 3);
        r.WriteInteger('CommandLineSafe', 0);
        r.WriteString('FriendlyName', 'Delphi Sample Add-In');
        r.WriteString('Description', 'Sample Add-In written in Delphi');
        r.CloseKey;
      end else
        raise EOleError.Create('Can''t register Add-In ' + ProgID)
    else
      if r.KeyExists(AddInKey) then
        r.DeleteKey(AddInKey);
  finally
    r.Free;
  end;
  inherited;
end;

{ TDelphiAddin1 }

procedure TDelphiAddin1.OnConnection(const Application: IDispatch;
  ConnectMode: ext_ConnectMode; const AddInInst: IDispatch;
  var custom: PSafeArray);
var
  s: WideString;
  x: OleVariant;
begin
  if ConnectMode <> ext_cm_CommandLine then
    try
      x:= Application;
      s:= 'Hello World!';
      s:= s + ' You''re running ' + x.Name + ' version ' + x.Version;
      MessageBoxW(0, PWideChar(s), '', MB_OK);
    except
    end;
end;

procedure TDelphiAddin1.OnDisconnection(RemoveMode: ext_DisconnectMode;
  var custom: PSafeArray);
begin
end;

procedure TDelphiAddin1.OnAddInsUpdate(var custom: PSafeArray);
begin
end;

procedure TDelphiAddin1.OnStartupComplete(var custom: PSafeArray);
begin
end;

procedure TDelphiAddin1.OnBeginShutdown(var custom: PSafeArray);
begin
end;

initialization
  TXLComAddinFactory.Create(ComServer, TDelphiAddin1, Class_DelphiAddin1,
    ciMultiInstance, tmApartment);
end.
