unit Unit1;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, ActiveX, XLCOMSample3_TLB, OleServer, OfficeXP, Contnrs, StdVcl;

type
  TXLComAddinFactory = class(TAutoObjectFactory)
    procedure UpdateRegistry(Register: Boolean); override;
  end;

// Constants for enum ext_ConnectMode
type
  ext_ConnectMode = TOleEnum;

const
  ext_cm_AfterStartup = $00000000;
  ext_cm_Startup = $00000001;
  ext_cm_External = $00000002;
  ext_cm_CommandLine = $00000003;

// Constants for enum ext_DisconnectMode
type
  ext_DisconnectMode = TOleEnum;

const
  ext_dm_HostShutdown = $00000000;
  ext_dm_UserClosed = $00000001;

type
  IDTExtensibility2 = interface(IDispatch)
    ['{B65AD801-ABAF-11D0-BB8B-00A0C90F2744}']
    procedure OnConnection(const Application: IDispatch;
                           ConnectMode: ext_ConnectMode;
                           const AddInInst: IDispatch;
                           var custom: PSafeArray); safecall;
    procedure OnDisconnection(RemoveMode: ext_DisconnectMode;
                              var custom: PSafeArray); safecall;
    procedure OnAddInsUpdate(var custom: PSafeArray); safecall;
    procedure OnStartupComplete(var custom: PSafeArray); safecall;
    procedure OnBeginShutdown(var custom: PSafeArray); safecall;
  end;

type
  IRibbonExtensibility = interface(IDispatch)
    ['{000C0396-0000-0000-C000-000000000046}']
    function GetCustomUI(const RibbonID: WideString): WideString; safecall;
  end;

type
  IRibbonControl = interface(IDispatch)
    ['{000C0395-0000-0000-C000-000000000046}']
    function Get_Id: WideString; safecall;
    function Get_Context: IDispatch; safecall;
    function Get_Tag: WideString; safecall;
    property Id: WideString read Get_Id;
    property Context: IDispatch read Get_Context;
    property Tag: WideString read Get_Tag;
  end;

type
  CommandBarButton_Click = procedure(const Ctrl: CommandBarButton;
                                     var CancelDefault: WordBool) of object;

type
  TCommandBarButton = class(TOleServer)
  private
    FIntf: _CommandBarButton;
    FOnClick: CommandBarButton_Click;
    function GetDefaultInterface: _CommandBarButton;
  protected
    procedure InitServerData; override;
    procedure InvokeEvent(DispID: TDispID; var Params: TVariantArray); override;
  public
    procedure Connect; override;
    procedure ConnectTo(svrIntf: _CommandBarButton);
    procedure Disconnect; override;
    property DefaultInterface: _CommandBarButton read GetDefaultInterface;
  published
    property OnClick: CommandBarButton_Click read FOnClick write FOnClick;
  end;

type
  TDelphiAddin3 = class(TAutoObject, IDelphiAddin3,
                        IDTExtensibility2, IRibbonExtensibility)
  private
    FApp: IDispatch;
    FBList: TObjectList;
    procedure BtnClick(const Ctrl: CommandBarButton;
                       var CancelDefault: WordBool);
    procedure InitButtons;
    procedure DestroyButtons;
    procedure DoSomething(const IdTag: Widestring);
    { IDTExtensibility2 }
    procedure OnConnection(const Application: IDispatch;
                           ConnectMode: ext_ConnectMode;
                           const AddInInst: IDispatch;
                           var custom: PSafeArray); safecall;
    procedure OnDisconnection(RemoveMode: ext_DisconnectMode;
                              var custom: PSafeArray); safecall;
    procedure OnAddInsUpdate(var custom: PSafeArray); safecall;
    procedure OnStartupComplete(var custom: PSafeArray); safecall;
    procedure OnBeginShutdown(var custom: PSafeArray); safecall;
    { IRibbonExtensibility }
    function GetCustomUI(const RibbonID: WideString): WideString; safecall;
  protected
    procedure RibbonClick(const Control: IDispatch); safecall;
  public
    procedure Initialize; override;
    Destructor Destroy; override;
  end;

implementation

uses
  ComServ, Windows, Registry, Variants, SysUtils, ExcelXP;

{ TXLComAddinFactory }

procedure TXLComAddinFactory.UpdateRegistry(Register: Boolean);
var
  RootKey: HKEY;
  AddInKey: String;
  r: TRegistry;
begin
  Rootkey:=HKEY_CURRENT_USER;
  AddInKey:='Software\Microsoft\Office\Excel\Addins\' + ProgID;
  r:=TRegistry.Create;
  r.RootKey:=RootKey;
  try
    if Register then
      if r.OpenKey(AddInKey, True) then begin
        r.WriteInteger('LoadBehavior', 3);
        r.WriteInteger('CommandLineSafe', 0);
        r.WriteString('FriendlyName', 'Delphi Sample Add-In');
        r.WriteString('Description', 'Sample Add-In written in Delphi');
        r.CloseKey;
      end else
        raise EOleError.Create('Can''t register Add-In ' + ProgID)
    else
      if r.KeyExists(AddInKey) then
        r.DeleteKey(AddInKey);
  finally
    r.Free;
  end;
  inherited;
end;

{ TCommandBarButton }

procedure TCommandBarButton.InitServerData;
const
  CServerData: TServerData = (
    ClassID:    '{55F88891-7708-11D1-ACEB-006008961DA5}';
    // CLASS_CommandBarButton;
    IntfIID:    '{000C030E-0000-0000-C000-000000000046}';
    // IID__CommandBarButton;
    EventIID:   '{000C0351-0000-0000-C000-000000000046}';
    // DIID__CommandBarButtonEvents;
    LicenseKey: nil;
    Version:    500);
begin
  ServerData:= @CServerData;
end;

procedure TCommandBarButton.Connect;
var
  punk: IUnknown;
begin
  if FIntf = nil then
  begin
    punk:= GetServer;
    ConnectEvents(punk);
    FIntf:= punk as _CommandBarButton;
  end;
end;

procedure TCommandBarButton.ConnectTo(svrIntf: _CommandBarButton);
begin
  Disconnect;
  FIntf:= svrIntf;
  ConnectEvents(FIntf);
end;

procedure TCommandBarButton.DisConnect;
begin
  if Fintf <> nil then begin
    DisconnectEvents(FIntf);
    FIntf:= nil;
  end;
end;

function TCommandBarButton.GetDefaultInterface: _CommandBarButton;
begin
  if FIntf = nil then
    Connect;
  Assert(FIntf <> nil, 'DefaultInterface is NULL.');
  Result:= FIntf;
end;

procedure TCommandBarButton.InvokeEvent(DispID: TDispID;
  var Params: TVariantArray);
begin
  case DispID of
   1 : if Assigned(FOnClick) then
         FOnClick(IUnknown(TVarData(Params[0]).VPointer)
                    as _CommandBarButton {const CommandBarButton},
                  WordBool((TVarData(Params[1]).VPointer)^)
                    {var WordBool});
  end;
end;

{ TDelphiAddin3 }

procedure TDelphiAddin3.Initialize;
begin
  inherited;
  // container for button handlers
  FBList:= TObjectList.Create;
end;

destructor TDelphiAddin3.Destroy;
begin
  FBList.Free;
  inherited;
end;

procedure TDelphiAddin3.BtnClick(const Ctrl: CommandBarButton;
  var CancelDefault: WordBool);
begin
  // tag used to identify buttons
  DoSomething(Ctrl.Tag);
end;

procedure TDelphiAddin3.RibbonClick(const Control: IDispatch);
begin
  // id used to identify buttons
  DoSomething((Control as IRibbonControl).Id);
end;

procedure TDelphiAddin3.DoSomething(const IdTag: Widestring);
var
  s: WideString;
begin
  s:='Hello World! ' + IdTag + ' clicked';
  MessageBoxW(0, PWideChar(s), '', MB_OK);
end;

procedure TDelphiAddin3.InitButtons;
const
  FIDs: array[1..5] of integer =
    (92, 104, 86, 91, 80);
var
  Excel: ExcelApplication;
  MBar: CommandBar;
  Button: TCommandBarButton;
  Popup: CommandBarPopup;
  i: integer;
  v: double;
  llcid: LCID;
begin
  // check host application
  if Assigned(FApp) and Supports(FApp, ExcelApplication, Excel) then begin
    // only for Excel 11 and before
    llcid:= GetUserDefaultLCID;
    Val(Excel.Version[llcid], v, i);
    if (i <> 0) or (v > 11) then
      Exit;
    // search the Bar
    try
      MBar:=Excel.CommandBars.Item['MyglaBar'];
      // assume that already initialized
      Excel:=nil;
      Exit;
      // alternative solution:
      //  FBList.Clear;
      // MBar.Delete;
    except  end;
    // create a Bar
    MBar:=Excel.CommandBars.Add('MyglaBar', msoBarTop,
                                 emptyParam, true);
    MBar.Set_Visible(true);

    // add Buttons to the Bar
    For i:=1 to 5 do begin
      Button:=TCommandBarButton.Create(nil);
      Button.OnClick:= Self.BtnClick;
      FBList.Add(Button);
      Button.ConnectTo(MBar.Controls.Add(msoControlButton,
                         emptyParam, emptyParam, emptyParam,
                         True) as CommandBarButton);
      Button.DefaultInterface.Set_Style(msoButtonIcon);
      Button.DefaultInterface.Set_BeginGroup(false);
      Button.DefaultInterface.Set_Caption('Mygla Button');
      Button.DefaultInterface.Set_FaceId(FIDs[i]);
      Button.DefaultInterface.Set_DescriptionText('A Sample Button');
      Button.DefaultInterface.Set_Enabled(true);
      Button.DefaultInterface.Set_TooltipText('This is a Button :)');
      Button.DefaultInterface.Set_Tag('Mygla_Button' +
                                      IntToStr(i)); // Tag for BtnClick
      Button.DefaultInterface.Set_Visible(true);
    end;

    // add a Popup Menu
    Popup:= MBar.Controls.Add(msoControlPopup,
                              emptyParam, emptyParam, emptyParam,
                              true) as CommandBarPopup;
    Popup.Set_BeginGroup(true);
    Popup.Set_Caption('Blog');
    Popup.Set_Visible(true);
    Popup.Set_TooltipText('This is a Popup Menu');

    // add Buttons to the Popup
    For i:=1 to 5 do begin
      Button:=TCommandBarButton.Create(nil);
      Button.OnClick:= Self.BtnClick;
      FBList.Add(Button);
      Button.ConnectTo(Popup.CommandBar.Controls.Add(msoControlButton,
                         emptyParam, emptyParam, emptyParam,
                         True) as CommandBarButton);
      Button.DefaultInterface.Set_Style(msoButtonIconAndCaption);
      Button.DefaultInterface.Set_BeginGroup(false);
      Button.DefaultInterface.Set_Width(80);
      Button.DefaultInterface.Set_Caption('Mygla Button');
      Button.DefaultInterface.Set_FaceId(FIDs[i]);
      Button.DefaultInterface.Set_DescriptionText('A Sample Button');
      Button.DefaultInterface.Set_Enabled(true);
      Button.DefaultInterface.Set_TooltipText('This is a Button :)');
      Button.DefaultInterface.Set_Tag('Mygla_Button' +
                                      IntToStr(i + 5)); // Tag for BtnClick
      Button.DefaultInterface.Set_Visible(true);
    end;
    // explicit release
    MBar:=nil;
    Excel:=nil;
  end;
end;

procedure TDelphiAddin3.DestroyButtons;
var
  Excel: ExcelApplication;
  MBar: CommandBar;
begin
  // disconnect button handlers
  FBList.Clear;
  // search the bar and delete it
  if Assigned(FApp) and Supports(FApp, ExcelApplication, Excel) then begin
    try
      MBar:=Excel.CommandBars.Item['MyglaBar'];
      MBar.Delete;
    except end;
    // explicit release
    Excel:=nil;
  end;
end;

{ TDelphiAddin3 - IDTExtensibility2}

procedure TDelphiAddin3.OnConnection(const Application: IDispatch;
  ConnectMode: ext_ConnectMode; const AddInInst: IDispatch;
  var custom: PSafeArray);
begin
  FApp:= Application;
  if ConnectMode = ext_cm_AfterStartup then
    InitButtons;
end;

procedure TDelphiAddin3.OnDisconnection(RemoveMode: ext_DisconnectMode;
  var custom: PSafeArray);
begin
  DestroyButtons;
  // release internal reference
  FApp:=nil;
end;

procedure TDelphiAddin3.OnAddInsUpdate(var custom: PSafeArray);
begin
end;

procedure TDelphiAddin3.OnStartupComplete(var custom: PSafeArray);
begin
  InitButtons;
end;

procedure TDelphiAddin3.OnBeginShutdown(var custom: PSafeArray);
begin
end;

{ TDelphiAddin3 - IRibbonExtensibility}

function TDelphiAddin3.GetCustomUI(const RibbonID: WideString): WideString;
begin
  result:=
    '<customUI xmlns="http://schemas.microsoft.com/office/2006/01/customui">'#13#10 +
    '  <ribbon>'#13#10 +
    '    <tabs>'#13#10 +
    '      <tab id="myglaTab" label="Mygla">'#13#10 +
    '        <group id="myglaGroup1" label="Mygla''s">'#13#10 +
    '          <button id="MyglaButton11" size="large" imageMso="M" onAction="RibbonClick"/>'#13#10 +
    '          <button id="MyglaButton12" size="large" imageMso="Y" onAction="RibbonClick"/>'#13#10 +
    '          <button id="MyglaButton13" size="large" imageMso="G" onAction="RibbonClick"/>'#13#10 +
    '          <button id="MyglaButton14" size="large" imageMso="L" onAction="RibbonClick"/>'#13#10 +
    '          <button id="MyglaButton15" size="large" imageMso="A" onAction="RibbonClick"/>'#13#10 +
    '        </group>'#13#10 +
    '        <group id="myglaGroup2" label="Buttons">'#13#10 +
    '          <menu id="myglaMenu" label="Blog">'#13#10 +
    '            <button id="MyglaButton16" label="Mygla Button" imageMso="M" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton17" label="Mygla Button" imageMso="Y" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton18" label="Mygla Button" imageMso="G" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton19" label="Mygla Button" imageMso="L" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton20" label="Mygla Button" imageMso="A" onAction="RibbonClick"/>'#13#10 +
    '          </menu>'#13#10 +
    '        </group>'#13#10 +
    '     </tab>'#13#10 +
    '   </tabs>'#13#10 +
    '  </ribbon>'#13#10 +
    '</customUI>';
end;

initialization
  TXLComAddinFactory.Create(ComServer, TDelphiAddin3, Class_DelphiAddin3,
    ciMultiInstance, tmApartment);
end.
