unit XLCOMSample3_TLB;

{$TYPEDADDRESS OFF}
{$WARN SYMBOL_PLATFORM OFF}
{$WRITEABLECONST ON}
{$VARPROPSETTER ON}
{$ALIGN 4}

interface

uses Windows, ActiveX, Classes, Variants;

const
  XLCOMSample3MajorVersion = 1;
  XLCOMSample3MinorVersion = 0;

  LIBID_XLCOMSample3: TGUID = '{2B59C407-1F66-4037-9E26-AFB12811EB46}';

  IID_IDelphiAddin3: TGUID = '{BB895687-08BB-42C4-A5B4-270F69F69826}';
  CLASS_DelphiAddin3: TGUID = '{2519E771-7534-4987-BA01-598C21CD26CB}';

type

  IDelphiAddin3 = interface;
  IDelphiAddin3Disp = dispinterface;

  DelphiAddin3 = IDelphiAddin3;

  IDelphiAddin3 = interface(IDispatch)
    ['{BB895687-08BB-42C4-A5B4-270F69F69826}']
    procedure RibbonClick(const Control: IDispatch); safecall;
  end;

  IDelphiAddin3Disp = dispinterface
    ['{BB895687-08BB-42C4-A5B4-270F69F69826}']
    procedure RibbonClick(const Control: IDispatch); dispid 1;
  end;

  CoDelphiAddin3 = class
    class function Create: IDelphiAddin3;
    class function CreateRemote(const MachineName: string): IDelphiAddin3;
  end;

implementation

uses ComObj;

class function CoDelphiAddin3.Create: IDelphiAddin3;
begin
  Result := CreateComObject(CLASS_DelphiAddin3) as IDelphiAddin3;
end;

class function CoDelphiAddin3.CreateRemote(const MachineName: string): IDelphiAddin3;
begin
  Result := CreateRemoteComObject(MachineName, CLASS_DelphiAddin3) as IDelphiAddin3;
end;

end.
