unit Unit1;

{$WARN SYMBOL_PLATFORM OFF}
{$ALIGN ON}

interface

uses
  ComObj, ActiveX, XLCOMSample4_TLB, OleServer, OfficeXP, Contnrs;

type
  TXLComAddinFactory = class(TAutoObjectFactory)
    procedure UpdateRegistry(Register: Boolean); override;
  end;

// Constants for enum ext_ConnectMode
type
  ext_ConnectMode = TOleEnum;

const
  ext_cm_AfterStartup = $00000000;
  ext_cm_Startup = $00000001;
  ext_cm_External = $00000002;
  ext_cm_CommandLine = $00000003;

// Constants for enum ext_DisconnectMode
type
  ext_DisconnectMode = TOleEnum;

const
  ext_dm_HostShutdown = $00000000;
  ext_dm_UserClosed = $00000001;

type
  IDTExtensibility2 = interface(IDispatch)
    ['{B65AD801-ABAF-11D0-BB8B-00A0C90F2744}']
    procedure OnConnection(const Application: IDispatch;
                           ConnectMode: ext_ConnectMode;
                           const AddInInst: IDispatch;
                           var custom: PSafeArray); safecall;
    procedure OnDisconnection(RemoveMode: ext_DisconnectMode;
                              var custom: PSafeArray); safecall;
    procedure OnAddInsUpdate(var custom: PSafeArray); safecall;
    procedure OnStartupComplete(var custom: PSafeArray); safecall;
    procedure OnBeginShutdown(var custom: PSafeArray); safecall;
  end;

type
  IRibbonExtensibility = interface(IDispatch)
    ['{000C0396-0000-0000-C000-000000000046}']
    function GetCustomUI(const RibbonID: WideString): WideString; safecall;
  end;

type
  IRibbonControl = interface(IDispatch)
    ['{000C0395-0000-0000-C000-000000000046}']
    function Get_Id: WideString; safecall;
    function Get_Context: IDispatch; safecall;
    function Get_Tag: WideString; safecall;
    property Id: WideString read Get_Id;
    property Context: IDispatch read Get_Context;
    property Tag: WideString read Get_Tag;
  end;

type
  CommandBarButton_Click = procedure(const Ctrl: CommandBarButton;
                                     var CancelDefault: WordBool) of object;

type
  TCommandBarButton = class(TOleServer)
  private
    FIntf: _CommandBarButton;
    FOnClick: CommandBarButton_Click;
    function GetDefaultInterface: _CommandBarButton;
  protected
    procedure InitServerData; override;
    procedure InvokeEvent(DispID: TDispID; var Params: TVariantArray); override;
  public
    procedure Connect; override;
    procedure ConnectTo(svrIntf: _CommandBarButton);
    procedure Disconnect; override;
    property DefaultInterface: _CommandBarButton read GetDefaultInterface;
  published
    property OnClick: CommandBarButton_Click read FOnClick write FOnClick;
  end;

type
  TDelphiAddin4 = class(TAutoObject, IDelphiAddin4,
                        IDTExtensibility2, IRibbonExtensibility)
  private
    FApp: IDispatch;
    FBList: TObjectList;
    procedure BtnClick(const Ctrl: CommandBarButton;
                       var CancelDefault: WordBool);
    procedure InitButtons;
    procedure DestroyButtons;
    procedure DoSomething(const IdTag: Widestring);
    function GetResPic(const ImgName: String;
      const Res: integer = 0): IPictureDisp;
    { IDTExtensibility2 }
    procedure OnConnection(const Application: IDispatch;
                           ConnectMode: ext_ConnectMode;
                           const AddInInst: IDispatch;
                           var custom: PSafeArray); safecall;
    procedure OnDisconnection(RemoveMode: ext_DisconnectMode;
                              var custom: PSafeArray); safecall;
    procedure OnAddInsUpdate(var custom: PSafeArray); safecall;
    procedure OnStartupComplete(var custom: PSafeArray); safecall;
    procedure OnBeginShutdown(var custom: PSafeArray); safecall;
    { IRibbonExtensibility }
    function GetCustomUI(const RibbonID: WideString): WideString; safecall;
  protected
    function GetImage(const ImageID: WideString): IPictureDisp; safecall;
    procedure RibbonClick(const Control: IDispatch); safecall;
  public
    procedure Initialize; override;
    Destructor Destroy; override;
  end;

implementation

uses
  ComServ, Windows, Registry, Variants, Classes, SysUtils, ExcelXP;

{ TXLComAddinFactory }

procedure TXLComAddinFactory.UpdateRegistry(Register: Boolean);
var
  RootKey: HKEY;
  AddInKey: String;
  r: TRegistry;
begin
  Rootkey:=HKEY_CURRENT_USER;
  AddInKey:='Software\Microsoft\Office\Excel\Addins\' + ProgID;
  r:=TRegistry.Create;
  r.RootKey:=RootKey;
  try
    if Register then
      if r.OpenKey(AddInKey, True) then begin
        r.WriteInteger('LoadBehavior', 3);
        r.WriteInteger('CommandLineSafe', 0);
        r.WriteString('FriendlyName', 'Delphi Sample Add-In');
        r.WriteString('Description', 'Sample Add-In written in Delphi');
        r.CloseKey;
      end else
        raise EOleError.Create('Can''t register Add-In ' + ProgID)
    else
      if r.KeyExists(AddInKey) then
        r.DeleteKey(AddInKey);
  finally
    r.Free;
  end;
  inherited;
end;

{ TCommandBarButton }

procedure TCommandBarButton.InitServerData;
const
  CServerData: TServerData = (
    ClassID:    '{55F88891-7708-11D1-ACEB-006008961DA5}';
    // CLASS_CommandBarButton;
    IntfIID:    '{000C030E-0000-0000-C000-000000000046}';
    // IID__CommandBarButton;
    EventIID:   '{000C0351-0000-0000-C000-000000000046}';
    // DIID__CommandBarButtonEvents;
    LicenseKey: nil;
    Version:    500);
begin
  ServerData:= @CServerData;
end;

procedure TCommandBarButton.Connect;
var
  punk: IUnknown;
begin
  if FIntf = nil then
  begin
    punk:= GetServer;
    ConnectEvents(punk);
    FIntf:= punk as _CommandBarButton;
  end;
end;

procedure TCommandBarButton.ConnectTo(svrIntf: _CommandBarButton);
begin
  Disconnect;
  FIntf:= svrIntf;
  ConnectEvents(FIntf);
end;

procedure TCommandBarButton.DisConnect;
begin
  if Fintf <> nil then begin
    DisconnectEvents(FIntf);
    FIntf:= nil;
  end;
end;

function TCommandBarButton.GetDefaultInterface: _CommandBarButton;
begin
  if FIntf = nil then
    Connect;
  Assert(FIntf <> nil, 'DefaultInterface is NULL.');
  Result:= FIntf;
end;

procedure TCommandBarButton.InvokeEvent(DispID: TDispID;
  var Params: TVariantArray);
begin
  case DispID of
   1 : if Assigned(FOnClick) then
         FOnClick(IUnknown(TVarData(Params[0]).VPointer)
                    as _CommandBarButton {const CommandBarButton},
                  WordBool((TVarData(Params[1]).VPointer)^)
                    {var WordBool});
  end;
end;

{ GDI+ }

const
  WINGDIPDLL = 'GdiPlus.dll';

type
  UINT32 = type Cardinal;
  ARGB   = DWORD;
  GpBitmap = Pointer;
  GpImage = Pointer;
  GpStatus = Cardinal;

  GdiplusStartupInput = packed record
    GdiplusVersion           : UINT32;  // always 1
    DebugEventCallback       : Pointer; // DebugEventProc
    SuppressBackgroundThread : BOOL;
    SuppressExternalCodecs   : BOOL;
  end;
  PGdiplusStartupInput = ^GdiplusStartupInput;

function GdiplusStartup(out token: PULONG; const input: PGdiplusStartupInput;
  {out} output: Pointer {PGdiplusStartupOutput}):
  GpStatus; stdcall; external WINGDIPDLL;

procedure GdiplusShutdown(token: PULONG); stdcall; external WINGDIPDLL;

function GdipCreateBitmapFromStream(stream: ISTREAM;
  out bitmap: GPBITMAP): GpStatus; stdcall; external WINGDIPDLL;

function GdipCreateHBITMAPFromBitmap(bitmap: GpBitmap; out hbmReturn: HBITMAP;
  background: ARGB): GpStatus; stdcall; external WINGDIPDLL;

function GdipCreateHICONFromBitmap(bitmap: GpBitmap; out hbmReturn: HICON):
  GpStatus; stdcall; external WINGDIPDLL;

function GdipDisposeImage(image: GpImage):
  GpStatus; stdcall; external WINGDIPDLL;

{ TDelphiAddin4 }

function TDelphiAddin4.GetResPic(const ImgName: String;
  const Res: integer = 0): ActiveX.IPictureDisp;
// Res: 0 GDI+ Bitmap RCDATA
//      1 LoadResource ICON
//      2 LoadResource BITMAP
var
  PictureDesc: TPictDesc;
  GPInput: GdiplusStartupInput;
  Status: GpStatus;
  Token: PULONG;
  ResStream: TResourceStream;
  ResStreamI: IStream;
  GPBM: GpBitmap;
  HBM: HBITMAP;
begin
  try
    case Res of
    0: begin
         FillChar(GPInput, SizeOf(GPInput), 0);
         GPInput.GdiplusVersion:= 1;
         Status:= GdiplusStartup(Token, @GPInput, nil);
         if Status = 0 then begin
           try
             ResStream:= TResourceStream.Create(HInstance, ImgName, RT_RCDATA);
             try
               ResStreamI:= TStreamAdapter.Create(ResStream);
               Status:= GdipCreateBitmapFromStream(ResStreamI, GPBM);
               if Status = 0 then begin
                 try
                   Status:= GdipCreateHBITMAPFromBitmap(GPBM, HBM, $00FFFFFF);
                   if Status = 0 then begin
                     FillChar(PictureDesc,SizeOf(PictureDesc),0);
                     PictureDesc.cbSizeOfStruct:= SizeOf(PictureDesc);
                     PictureDesc.picType:= PICTYPE_BITMAP;
                     PictureDesc.hbitmap:= HBM;
                     OleCheck(OleCreatePictureIndirect(PictureDesc,
                        ActiveX.IPicture, true, Result));
                   end;
                 finally
                   GdipDisposeImage(GPBM);
                 end;
               end;
             finally
               ResStream.Free;
               ResStreamI:= nil;
             end;
           finally
             GdiplusShutdown(Token);
           end;
         end;
       end;
    1: begin
         FillChar(PictureDesc, SizeOf(PictureDesc), 0);
         PictureDesc.cbSizeOfStruct:= SizeOf(PictureDesc);
         PictureDesc.picType := PICTYPE_ICON;
         PictureDesc.hIcon := LoadIcon(HInstance, PChar(ImgName));
         OleCheck(OleCreatePictureIndirect(PictureDesc,
                    ActiveX.IPicture, true, Result));
       end;
    2: begin
         FillChar(PictureDesc, SizeOf(PictureDesc), 0);
         PictureDesc.cbSizeOfStruct:= SizeOf(PictureDesc);
         PictureDesc.picType := PICTYPE_BITMAP;
         PictureDesc.hbitmap := LoadBitmap(HInstance, PChar(ImgName));
         OleCheck(OleCreatePictureIndirect(PictureDesc,
                    ActiveX.IPicture, true, Result));
       end;
    else
      Result:= nil;
    end;
  except
    Result:= nil;
  end;
end;

procedure TDelphiAddin4.Initialize;
begin
  inherited;
  // container for button handlers
  FBList:= TObjectList.Create;
end;

destructor TDelphiAddin4.Destroy;
begin
  FBList.Free;
  inherited;
end;

procedure TDelphiAddin4.BtnClick(const Ctrl: CommandBarButton;
  var CancelDefault: WordBool);
begin
  // tag used to identify buttons
  DoSomething(Ctrl.Tag);
end;

procedure TDelphiAddin4.RibbonClick(const Control: IDispatch);
begin
  // id used to identify buttons
  DoSomething((Control as IRibbonControl).Id);
end;

procedure TDelphiAddin4.DoSomething(const IdTag: Widestring);
var
  s: WideString;
begin
  s:='Hello World! ' + IdTag + ' clicked';
  MessageBoxW(0, PWideChar(s), '', MB_OK);
end;

procedure TDelphiAddin4.InitButtons;
const
  FIDs: String = 'MYGLA';
var
  Excel: ExcelApplication;
  MBar: CommandBar;
  Button: TCommandBarButton;
  Popup: CommandBarPopup;
  i: integer;
  v: double;
  llcid: LCID;
begin
  // check host application
  if Assigned(FApp) and Supports(FApp, ExcelApplication, Excel) then begin
    // only for Excel 11 and before
    llcid:= GetUserDefaultLCID;
    Val(Excel.Version[llcid], v, i);
    if (i <> 0) or (v > 11) then
      Exit;

    // search the Bar
    try
      MBar:=Excel.CommandBars.Item['MyglaBar'];
      // assume that already initialized
      Excel:=nil;
      Exit;
      // alternative solution:
      //  FBList.Clear;
      // MBar.Delete;
    except  end;
    // create a Bar
    MBar:=Excel.CommandBars.Add('MyglaBar', msoBarTop,
                                 emptyParam, true);
    MBar.Set_Visible(true);

    // add Buttons to the Bar
    For i:=1 to 5 do begin
      Button:=TCommandBarButton.Create(nil);
      Button.OnClick:= Self.BtnClick;
      FBList.Add(Button);
      Button.ConnectTo(MBar.Controls.Add(msoControlButton,
                         emptyParam, emptyParam, emptyParam,
                         True) as CommandBarButton);
      Button.DefaultInterface.Set_Style(msoButtonIcon);
      Button.DefaultInterface.Set_BeginGroup(false);
      Button.DefaultInterface.Set_Caption('Mygla Button');
      Button.DefaultInterface.Set_FaceId(0);
      Button.DefaultInterface.Set_Picture(
        GetResPic('Letter'+ FIDs[i]+'_ico', 0));
      Button.DefaultInterface.Set_DescriptionText('A Sample Button');
      Button.DefaultInterface.Set_Enabled(true);
      Button.DefaultInterface.Set_TooltipText('This is a Button :)');
      Button.DefaultInterface.Set_Tag('Mygla_Button' +
                                      IntToStr(i)); // Tag for BtnClick
      Button.DefaultInterface.Set_Visible(true);
    end;

    // add a Popup Menu
    Popup:= MBar.Controls.Add(msoControlPopup,
                              emptyParam, emptyParam, emptyParam,
                              true) as CommandBarPopup;
    Popup.Set_BeginGroup(true);
    Popup.Set_Caption('Blog');
    Popup.Set_Visible(true);
    Popup.Set_TooltipText('This is a Popup Menu');

    // add Buttons to the Popup
    For i:=1 to 5 do begin
      Button:=TCommandBarButton.Create(nil);
      Button.OnClick:= Self.BtnClick;
      FBList.Add(Button);
      Button.ConnectTo(Popup.CommandBar.Controls.Add(msoControlButton,
                         emptyParam, emptyParam, emptyParam,
                         True) as CommandBarButton);
      Button.DefaultInterface.Set_Style(msoButtonIconAndCaption);
      Button.DefaultInterface.Set_BeginGroup(false);
      Button.DefaultInterface.Set_Width(80);
      Button.DefaultInterface.Set_Caption('Mygla Button');
      Button.DefaultInterface.Set_FaceId(0);
      Button.DefaultInterface.Set_Picture(
        GetResPic('Letter'+ FIDs[i]+'_bmp', 2));
      Button.DefaultInterface.Set_DescriptionText('A Sample Button');
      Button.DefaultInterface.Set_Enabled(true);
      Button.DefaultInterface.Set_TooltipText('This is a Button :)');
      Button.DefaultInterface.Set_Tag('Mygla_Button' +
                                      IntToStr(i + 5)); // Tag for BtnClick
      Button.DefaultInterface.Set_Visible(true);
    end;
    // explicit release
    MBar:=nil;
    Excel:=nil;
  end;
end;

procedure TDelphiAddin4.DestroyButtons;
var
  Excel: ExcelApplication;
  MBar: CommandBar;
begin
  // disconnect button handlers
  FBList.Clear;
  // search the bar and delete it
  if Assigned(FApp) and Supports(FApp, ExcelApplication, Excel) then begin
    try
      MBar:=Excel.CommandBars.Item['MyglaBar'];
      MBar.Delete;
    except end;
    // explicit release
    Excel:=nil;
  end;
end;

function TDelphiAddin4.GetImage(const ImageID: WideString): IPictureDisp;
var
  s: String;
  i: integer;
begin
  s:= ImageID;
  i:= length(s);
  if i > 3 then
    s[i-3]:= '_';

  if ImageID = 'Mygla.ico' then begin
    Result:= GetResPic(s, 1);
    exit;
  end;

  Result:= GetResPic(s);
end;

{ TDelphiAddin4 - IDTExtensibility2}

procedure TDelphiAddin4.OnConnection(const Application: IDispatch;
  ConnectMode: ext_ConnectMode; const AddInInst: IDispatch;
  var custom: PSafeArray);
begin
  FApp:= Application;
  if ConnectMode = ext_cm_AfterStartup then
    InitButtons;
end;

procedure TDelphiAddin4.OnDisconnection(RemoveMode: ext_DisconnectMode;
  var custom: PSafeArray);
begin
  DestroyButtons;
  // release internal reference
  FApp:=nil;
end;

procedure TDelphiAddin4.OnAddInsUpdate(var custom: PSafeArray);
begin
end;

procedure TDelphiAddin4.OnStartupComplete(var custom: PSafeArray);
begin
  InitButtons;
end;

procedure TDelphiAddin4.OnBeginShutdown(var custom: PSafeArray);
begin
end;

{ TDelphiAddin4 - IRibbonExtensibility}

function TDelphiAddin4.GetCustomUI(const RibbonID: WideString): WideString;
begin
  result:=
    '<customUI xmlns="http://schemas.microsoft.com/office/2006/01/customui" loadImage="GetImage">'#13#10 +
    '  <ribbon>'#13#10 +
    '    <tabs>'#13#10 +
    '      <tab id="myglaTab" label="Mygla">'#13#10 +
    '        <group id="myglaGroup1" label="Mygla''s">'#13#10 +
    '          <button id="MyglaButton11" size="large" image="Mygla.bmp" onAction="RibbonClick"/>'#13#10 +
    '          <button id="MyglaButton12" size="large" image="Mygla.png" onAction="RibbonClick"/>'#13#10 +
    '          <button id="MyglaButton13" size="large" image="Mygla.ico" onAction="RibbonClick"/>'#13#10 +
    '        </group>'#13#10 +
    '        <group id="myglaGroup2" label="Buttons">'#13#10 +
    '          <menu id="myglaMenu" label="Blog">'#13#10 +
    '            <button id="MyglaButton14" label="Mygla Button" image="LetterM.png" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton15" label="Mygla Button" image="LetterY.png" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton16" label="Mygla Button" image="LetterG.png" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton17" label="Mygla Button" image="LetterL.png" onAction="RibbonClick"/>'#13#10 +
    '            <button id="MyglaButton18" label="Mygla Button" image="LetterA.png" onAction="RibbonClick"/>'#13#10 +
    '          </menu>'#13#10 +
    '        </group>'#13#10 +
    '     </tab>'#13#10 +
    '   </tabs>'#13#10 +
    '  </ribbon>'#13#10 +
    '</customUI>';
end;

initialization
  TXLComAddinFactory.Create(ComServer, TDelphiAddin4, Class_DelphiAddin4,
    ciMultiInstance, tmApartment);
end.
