unit XLCOMSample4_TLB;

{$TYPEDADDRESS OFF}
{$WARN SYMBOL_PLATFORM OFF}
{$WRITEABLECONST ON}
{$VARPROPSETTER ON}
{$ALIGN 4}
interface

uses Windows, ActiveX, Classes, Variants;

const
  XLCOMSample4MajorVersion = 1;
  XLCOMSample4MinorVersion = 0;

  LIBID_XLCOMSample4: TGUID = '{6C29D36D-1B89-4936-A8D5-6066CA044FFB}';

  IID_IDelphiAddin4: TGUID = '{EF97A441-613E-413F-BC31-CD14F3B92FCE}';
  CLASS_DelphiAddin4: TGUID = '{D026CA98-1DC5-4531-8005-325D80646D0E}';

type
  IDelphiAddin4 = interface;
  IDelphiAddin4Disp = dispinterface;

  DelphiAddin4 = IDelphiAddin4;

  IDelphiAddin4 = interface(IDispatch)
    ['{EF97A441-613E-413F-BC31-CD14F3B92FCE}']
    procedure RibbonClick(const Control: IDispatch); safecall;
    function GetImage(const ImageID: WideString): IPictureDisp; safecall;
  end;

  IDelphiAddin4Disp = dispinterface
    ['{EF97A441-613E-413F-BC31-CD14F3B92FCE}']
    procedure RibbonClick(const Control: IDispatch); dispid 1;
    function GetImage(const ImageID: WideString): IPictureDisp; dispid 2;
  end;

  CoDelphiAddin4 = class
    class function Create: IDelphiAddin4;
    class function CreateRemote(const MachineName: string): IDelphiAddin4;
  end;

implementation

uses ComObj;

class function CoDelphiAddin4.Create: IDelphiAddin4;
begin
  Result := CreateComObject(CLASS_DelphiAddin4) as IDelphiAddin4;
end;

class function CoDelphiAddin4.CreateRemote(const MachineName: string): IDelphiAddin4;
begin
  Result := CreateRemoteComObject(MachineName, CLASS_DelphiAddin4) as IDelphiAddin4;
end;

end.
