{ *********************************************************************** }
{                                                                         }
{ Copyright (c) 2013 Edgar Gttel                                         }
{                                                                         }
{ *********************************************************************** }
library SampleXLLMenu;

uses
  dXLCall, dXLUtils;

{$E XLL}

const
  XLLName : String[20] = 'Menu Add-In';
  Msg : String[20] = 'Hello World';
  FncP : String[20] = 'SampleFunc';
  FncT : String[20] = 'P';
  FncF : String[20] = 'HelloFnc';

  CmdP : String[20] = 'MenuCommand';
  CmdT : String[20] = 'J';
  CmdF : String[20] = 'SampleCommand';

  cMenuItems : array[0..23] of String[20] =
  ('M&y Xtray Menu', '','','',
   'Menu &Item 01', 'SampleCommand', '', 'shows a msgbox',
   'Menu I&tem 02', 'SampleCommand', '', 'shows a msgbox',
   '-', '','','',
   'Menu It&em 03', 'SampleCommand', '', 'shows a msgbox',
   'Menu Ite&m 04', 'SampleCommand', '', 'shows a msgbox');

var
  isRegistered: Boolean;
  res, Arg1, Arg2, Arg3, Arg4, Arg5, Arg6 : xloper;

function CheckMenu: Boolean;
var
  res, mArg1, mArg2, mArg3: xloper;
begin
  result:= True;                  // menu does not exist
  mArg1.xltype:= xlTypeInt;
  mArg1.val.w:= 10;
  mArg2.xltype:= xlTypeStr;
  mArg2.val.str:= @cMenuItems[0]; // menu name or number
  mArg3.xltype:= xlTypeMissing;
  if Excel4e(xlfGetBar, res, 3,
     [@mArg1, @mArg2, @mArg3]) = xlretSuccess then
    if res.xltype <> xlTypeErr then
      result:= False;             // menu exists
end;

procedure AddMenu;
var
  mArg1, mArg2, mArg3, mArg4: xloper;
  mArgX: array[0..23] of xloper;
  i: Integer;
begin
  if CheckMenu then begin // check if already created
    mArg1.xltype:= xlTypeInt;
    mArg1.val.w:= 10;             // default menu bar
    mArg2.xltype:= xlTypeMulti;
    mArg2.val.xarray.columns:= 4; // size of
    mArg2.val.xarray.rows:= 6;    // array
    mArg2.val.xarray.lparray:= @mArgX[0];
    for i:=0 to 23 do begin
      mArgX[i].xltype:= xlTypeStr;
      mArgX[i].val.str:= @cMenuItems[i];
    end;
    Excel4e(xlfAddMenu, nil, 2,
            [@mArg1, @mArg2]); // add menu
    //*************************************************
    mArg3.xltype:= xlTypeStr;
    mArg3.val.str:= @cMenuItems[0]; // menu to add sub
    mArg4.xltype:= xlTypeInt;
    mArg4.val.w:= 4;                // pos for sub
    Excel4e(xlfAddMenu, nil, 4,
      [@mArg1, @mArg2, @mArg3, @mArg4]); // add submenu
  end;
end;

procedure DelMenu;
var
  mArg1, mArg2: xloper;
begin
    mArg1.xltype:= xlTypeInt;
    mArg1.val.w:= 10;               // default menu bar
    mArg2.xltype:= xlTypeStr;
    mArg2.val.str:= @cMenuItems[0]; // menu to delete
    Excel4e(xlfDeleteMenu, nil, 2,
      [@mArg1, @mArg2]);            // delete
end;

function MenuCommand: integer; stdcall;
var
  s: ShortString;
  x: xloper;
begin
  s:='Hello World';
  x.xltype:= xltypeStr;
  x.val.str:= @s;
  Excel4e(xlcAlert, nil, 1, [@x]);
  result:=1;
end;

function SampleFunc: LPXLOPER; stdcall;
begin
  res.xltype:= xltypeStr;
  res.val.str:= @Msg;
  result:=@res;
end;

function xlAddInManagerInfo(pxAction: LPXLOPER): LPXLOPER; stdcall;
begin
  if ((pxAction.xltype = xltypeInt)and(pxAction.val.w = 1))or
     ((pxAction.xltype = xltypeNum)and(pxAction.val.num = 1)) then begin
    res.xltype:= xltypeStr;
    res.val.Str:= @XLLName;
  end
  else begin
    res.xltype:= xltypeErr;
    res.val.err:= xlerrValue;
  end;
  result:=@res;
end;

function xlAutoOpen: integer; stdcall;
begin
  if not isRegistered then begin
    Excel4e(xlGetName, @Arg1);        // dll name as pxModuleText
    Arg2.xltype:= xltypeStr;
    Arg2.val.str:= @FncP;
    Arg3.xltype:= xltypeStr;
    Arg3.val.str:= @FncT;
    Arg4.xltype:= xltypeStr;
    Arg4.val.str:= @FncF;
    Excel4e(xlfRegister, nil, 4,      // registers the function
      [@Arg1, @Arg2, @Arg3, @Arg4]);
    //****************************************
    // register menu command
    Arg2.val.str:= @CmdP;
    Arg3.val.str:= @CmdT;         // always "J"
    Arg4.val.str:= @CmdF;
    Arg5.xltype:= xltypeMissing; // not required for commands
    Arg6.xltype:= xltypeInt;
    Arg6.val.w:= 2;              // 2 = command
    Excel4e(xlfRegister, nil, 6, // registers the command
      [@Arg1, @Arg2, @Arg3, @Arg4, @Arg5, @Arg6]);
    AddMenu;
    //****************************************
    Excel4e(xlFree, nil, 1, [@Arg1]); // free this string!
    isRegistered:= true;
  end;
  result:= 1;
end;

function xlAutoRemove: integer; stdcall;
begin
  if isRegistered then begin
    Excel4e(xlGetName, @Arg1);         // dll name as pxModuleText
    Arg2.xltype:= xltypeStr;
    Arg2.val.str:= @FncP;
    Arg3.xltype:= xltypeStr;
    Arg3.val.str:= @FncT;
    Arg4.xltype:= xltypeStr;
    Arg4.val.str:= @FncF;
    Excel4e(xlfRegisterId, @res, 3,    // for Unregister
      [@Arg1, @Arg2, @Arg3]);
    Excel4e(xlfSetName, nil, 1, [@Arg4]);   // delete name
    Excel4e(xlfUnregister, nil, 1, [@res]); // unregister function
    //****************************************
    Arg2.val.str:= @CmdP;
    Arg3.val.str:= @CmdT;
    Arg4.val.str:= @CmdF;
    Excel4e(xlfRegisterId, @res, 3,         // for Unregister
      [@Arg1, @Arg2, @Arg3]);
    Excel4e(xlfSetName, nil, 1, [@Arg4]);   // delete name
    Excel4e(xlfUnregister, nil, 1, [@res]); // unregister command
    DelMenu;
    //****************************************
    Excel4e(xlFree, nil, 1, [@Arg1]);  // free this string!
    isRegistered:= false;
  end;
  result:= 1;
end;

exports
  SampleFunc,
  MenuCommand, // command called by custom menu
  xlAddInManagerInfo,
  xlAutoOpen,
  xlAutoRemove;

begin
  isRegistered:=false;
end.

