{ *********************************************************************** }
{                                                                         }
{ Copyright (c) 2014 Edgar Goettel                                        }
{                                                                         }
{ *********************************************************************** }
library RangeXLL;

uses
  dXLCall, dXLUtils, SysUtils;

{$E XLL}

const
  XLLName : PAnsiChar = #17'Range Demo Add-In';
  FncP : PAnsiChar = #10'SampleFunc';
  FncT : PAnsiChar = #02'PP';
  FncF : PAnsiChar = #8'RangeFnc';

var
  isRegistered: Boolean;
  res, Arg1, Arg2, Arg3, Arg4 : xloper;
  Msg: ShortString;

function SampleFunc(x: LPXLOPER): LPXLOPER; stdcall;
type
  tmulti = array[0..0] of XLOPER;
  pmulti = ^tmulti;
var
  oper: XLOPER;
  i, j: Integer;
  lsum: Double;
  lchar, lbool, lerr, lempty: Integer;
begin
  case (x.xltype and $0FFF) of
    xltypeNum     : Msg:= 'number';
    xltypeStr     : Msg:= 'string';
    xltypeBool    : Msg:= 'bool';
    xltypeErr     : Msg:= 'error';
    xltypeMissing : Msg:= 'nothing';
    xltypeNil     : Msg:= 'empty cell';
    xltypeMulti   : begin
      with x.val.xarray do begin
        lsum:=0;
        lchar:= 0;
        lbool:=0;
        lerr:=0;
        lempty:=0;
        for i:=0 to rows - 1 do begin
          for j:=0 to columns - 1 do begin
            oper:= pmulti(lparray)[i * columns + j];
            case (oper.xltype and $0FFF) of
              xltypeNum : lsum:= lsum + oper.val.num;
              xltypeStr : lchar:= lchar +
                Length(PShortString(oper.val.str)^);
              xltypeBool: inc(lbool);
              xltypeErr : inc(lerr);
              xltypeNil : inc(lempty);
            end;
          end;
        end;
        Msg:= 'range ' +
              IntToStr(rows)    + 'rows ' +
              IntToStr(columns) + 'cols ' +
              '; sum: '    + FloatToStr(lsum) +
              '; chars: '  + IntToStr(lchar) +
              '; bools: '  + IntToStr(lbool) +
              '; errors: ' + IntToStr(lerr) +
              '; empty: '  + IntToStr(lempty);
      end;
    end;
  end;
  if (x.xltype and xlbitXLFree) = xlbitXLFree then begin
    Msg:= Msg + ' XLFree';
    Excel4e(xlFree, nil, 1, [x]);
  end;
  res.xltype:= xltypeStr;
  res.val.str:= @Msg;
  result:=@res;
end;

function xlAddInManagerInfo(pxAction: LPXLOPER): LPXLOPER; stdcall;
begin
  if ((pxAction.xltype = xltypeInt)and(pxAction.val.w = 1))or
     ((pxAction.xltype = xltypeNum)and(pxAction.val.num = 1)) then begin
    res.xltype:= xltypeStr;
    res.val.Str:= XLLName;
  end
  else begin
    res.xltype:= xltypeErr;
    res.val.err:= xlerrValue;
  end;
  result:=@res;
end;

function xlAutoOpen: integer; stdcall;
begin
  if not isRegistered then begin
    Excel4e(xlGetName, @Arg1);        // dll name as pxModuleText
    Arg2.xltype:= xltypeStr;
    Arg2.val.str:= FncP;
    Arg3.xltype:= xltypeStr;
    Arg3.val.str:= FncT;
    Arg4.xltype:= xltypeStr;
    Arg4.val.str:= FncF;
    Excel4e(xlfRegister, nil, 4,      // registers the function
      [@Arg1, @Arg2, @Arg3, @Arg4]);
    Excel4e(xlFree, nil, 1, [@Arg1]); // free this string!
    isRegistered:= true;
  end;
  result:= 1;
end;

function xlAutoRemove: integer; stdcall;
begin
  if isRegistered then begin
    Excel4e(xlGetName, @Arg1);         // dll name as pxModuleText
    Arg2.xltype:= xltypeStr;
    Arg2.val.str:= FncP;
    Arg3.xltype:= xltypeStr;
    Arg3.val.str:= FncT;
    Arg4.xltype:= xltypeStr;
    Arg4.val.str:= FncF;
    Excel4e(xlfRegisterId, @res, 3,    // for Unregister
      [@Arg1, @Arg2, @Arg3]);
    Excel4e(xlfSetName, nil, 1, [@Arg4]);   // delete name
    Excel4e(xlfUnregister, nil, 1, [@res]); // unregister function
    Excel4e(xlFree, nil, 1, [@Arg1]);  // free this string!
    isRegistered:= false;
  end;
  result:= 1;
end;

exports
  SampleFunc,
  xlAddInManagerInfo,
  xlAutoOpen,
  xlAutoRemove;

begin
  isRegistered:=false;
end.

